
%% Matlab Code for generating Gaussian white noise in the range of -10 to 10 dB in steps of 1 dB and 201 test signals for each SNR
clc;
close all;
%% Load 10 identical simulated ATS coarse crackles here
load SC1_ATS
load SC2_ATS
load SC3_ATS
load SC4_ATS
load SC5_ATS
load SC6_ATS
load SC7_ATS
load SC8_ATS
load SC9_ATS
load SC10_ATS
fs              = 44100;                                                      %% Sampling frequency
Signal_length   = 32768;                                                      %% Signal length
%% Make the length equal
SC1_ATS         = [zeros(1,1000),SC1_ATS,zeros(1,Signal_length-(1000+length(SC1_ATS)))];
SC2_ATS         = [zeros(1,3000),SC2_ATS,zeros(1,Signal_length-(3000+length(SC2_ATS)))];
SC3_ATS         = [zeros(1,7000),SC3_ATS,zeros(1,Signal_length-(7000+length(SC3_ATS)))];
SC4_ATS         = [zeros(1,12000),SC4_ATS,zeros(1,Signal_length-(12000+length(SC4_ATS)))];
SC5_ATS         = [zeros(1,14000),SC5_ATS,zeros(1,Signal_length-(14000+length(SC5_ATS)))];
SC6_ATS         = [zeros(1,17000),SC6_ATS,zeros(1,Signal_length-(17000+length(SC6_ATS)))];
SC7_ATS         = [zeros(1,20000),SC7_ATS,zeros(1,Signal_length-(20000+length(SC7_ATS)))];
SC8_ATS         = [zeros(1,23000),SC8_ATS,zeros(1,Signal_length-(23000+length(SC8_ATS)))];
SC9_ATS         = [zeros(1,27500),SC9_ATS,zeros(1,Signal_length-(27500+length(SC9_ATS)))];
SC10_ATS        = [zeros(1,30000),SC10_ATS,zeros(1,Signal_length-(30000+length(SC10_ATS)))];
Ten_identical_simulated_ATS_coarse_crackles         = SC1_ATS+SC2_ATS+SC3_ATS+SC4_ATS+SC5_ATS+SC6_ATS+SC7_ATS+SC8_ATS+SC9_ATS+SC10_ATS;
Ten_identical_simulated_ATS_coarse_crackles         = Ten_identical_simulated_ATS_coarse_crackles(1:end);                                                             
%% Preallocate variables here


%% Start SNR and Iterative loops
for SNR_loop        = -10:1:10                                                 %% Start signal to noise ratio loop
for iterative_loop  = 1:201                                                    %% Start number of iterations loop 
%% Generate Gaussian white noise
Signal      = awgn(Ten_identical_simulated_ATS_coarse_crackles,SNR_loop,'measured');  %% Signal with 10 identical ATS coarse crackles buried under Gaussian white noise
                                                                 

%% Use your separation technique here



end
end